/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.ConnectionTriggerManager;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.interpret.Statement;

public class DropTrigger
extends Statement {
    String trigger_name;

    public void prepare() throws DatabaseException {
        this.trigger_name = (String)this.cmd.getObject("trigger_name");
    }

    public Table evaluate() throws DatabaseException {
        String type = (String)this.cmd.getObject("type");
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        if (type.equals("callback_trigger")) {
            this.database.deleteTrigger(this.trigger_name);
        } else {
            String schema_name = this.database.getCurrentSchema();
            TableName t_name = TableName.resolve(schema_name, this.trigger_name);
            t_name = this.database.tryResolveCase(t_name);
            ConnectionTriggerManager manager = this.database.getConnectionTriggerManager();
            manager.dropTrigger(t_name.getSchema(), t_name.getName());
            this.database.getGrantManager().revokeAllGrantsOnObject(1, t_name.toString());
        }
        return FunctionTable.resultTable(context, 0);
    }
}

